package org.msh.tb.indicators;

import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.msh.tb.entities.enums.MessageKey;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;

@Name("enumFilterOptionConverter")
@org.jboss.seam.annotations.faces.Converter(id="enumFilterOptionConverter")
@BypassInterceptors
public class EnumFilterOptionConverter implements Converter {
    @Override
    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String s) {
        if (s.equals("UNDEFINED")) {
            // create undefined option
            EnumFilterOption undefined = new EnumFilterOption();
            undefined.setValue(null);
            undefined.setUndefined(true);
            return undefined;
        }

        String enumClazzStr = s.substring(0, s.indexOf("-"));
        String enumValueStr = s.substring(s.indexOf("-") + 1, s.length());
        MessageKey enumValue;

        try {
            Class<Enum> enumClazz = (Class<Enum>) Class.forName(enumClazzStr);
            enumValue = (MessageKey) Enum.valueOf(enumClazz, enumValueStr);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }

        return new EnumFilterOption(enumValue);
    }

    @Override
    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object o) {
        EnumFilterOption efo = (EnumFilterOption) o;

        if (efo == null) {
            return null;
        }

        if (efo.isUndefined()) {
            return "UNDEFINED";
        }

        return efo.getValue().getClass().getCanonicalName() + "-" + efo.getValue().toString();
    }
}
